/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.HammockBlock;
import com.illusivesoulworks.comforts.common.block.SleepingBagBlock;
import com.illusivesoulworks.comforts.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;

public class ComfortsEvents {
    static final List<class_1293> SLEEPING_BAG_EFFECTS = new ArrayList<class_1293>();

    public static boolean canSetSpawn(class_1657 player, class_2338 pos) {
        class_1937 level = player.method_37908();
        if (pos != null && !player.method_37908().field_9236) {
            class_2248 block = level.method_8320(pos).method_26204();
            return !(block instanceof SleepingBagBlock) && !(block instanceof HammockBlock);
        }
        return true;
    }

    public static Result checkTime(class_1937 level, class_2338 pos) {
        long time = level.method_8532() % 24000L;
        if (level.method_8320(pos).method_26204() instanceof HammockBlock) {
            if (time > 500L && time < 11500L) {
                return Result.ALLOW;
            }
            if (((Boolean)ComfortsConfig.SERVER.nightHammocks.get()).booleanValue()) {
                return Result.DEFAULT;
            }
            return Result.DENY;
        }
        return Result.DEFAULT;
    }

    public static long getWakeTime(class_3218 level, long currentTime) {
        boolean[] activeHammock = new boolean[]{false};
        List players = level.method_18456();
        for (class_1657 player : players) {
            player.method_18398().ifPresent(bedPos -> {
                if (player.method_7276() && level.method_8320(bedPos).method_26204() instanceof HammockBlock) {
                    activeHammock[0] = true;
                }
            });
            if (!activeHammock[0]) continue;
            break;
        }
        if (activeHammock[0] && level.method_8410().method_8530()) {
            long i = level.method_8532() + 24000L;
            return i - i % 24000L - 12001L;
        }
        return currentTime;
    }

    public static void onWakeUp(class_1657 player) {
        class_1937 level = player.method_37908();
        if (!level.field_9236) {
            Services.SLEEP_EVENTS.getSleepData(player).ifPresent(data -> player.method_18398().ifPresent(bedPos -> {
                long wakeTime = level.method_8532();
                long timeSlept = wakeTime - data.getSleepTime();
                class_2680 state = level.method_8320(bedPos);
                if (state.method_26204() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        class_1324 attributeInstance;
                        List<class_1293> effectInstances = SLEEPING_BAG_EFFECTS;
                        if (!effectInstances.isEmpty()) {
                            for (class_1293 effect : effectInstances) {
                                player.method_6092(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578()));
                            }
                        }
                        double breakChance = (Double)ComfortsConfig.SERVER.sleepingBagBreakage.get();
                        double luckMultiplier = (Double)ComfortsConfig.SERVER.sleepingBagBreakageLuckMultiplier.get();
                        if (luckMultiplier > 0.0 && (attributeInstance = player.method_5996(class_5134.field_23726)) != null) {
                            breakChance -= luckMultiplier * attributeInstance.method_6194();
                        }
                        if (level.field_9229.method_43058() < breakChance) {
                            broke = true;
                            class_2338 blockpos = bedPos.method_10093(((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10153());
                            level.method_8650(bedPos, false);
                            level.method_8650(blockpos, false);
                            player.method_7353((class_2561)class_2561.method_43471((String)"block.comforts.sleeping_bag.broke"), true);
                            level.method_8396(null, bedPos, class_3417.field_14983, class_3419.field_15245, 1.0f, 1.0f);
                            player.method_18399();
                        }
                    }
                    if (!broke && data.getAutoSleepPos() != null) {
                        class_2338 blockpos = bedPos.method_10093(((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10153());
                        level.method_8650(blockpos, false);
                        level.method_8650(bedPos, false);
                        player.method_18399();
                    }
                }
                data.setWakeTime(wakeTime);
                data.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.sleepyFactor.get()));
                data.setAutoSleepPos(null);
            }));
        }
    }

    public static class_1657.class_1658 onSleep(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            return Services.SLEEP_EVENTS.getSleepData(player).map(data -> {
                long dayTime = player.method_5770().method_8532();
                data.setSleepTime(dayTime);
                if (((Boolean)ComfortsConfig.SERVER.wellRested.get()).booleanValue()) {
                    if (data.getWakeTime() > dayTime) {
                        data.setWakeTime(0L);
                        data.setTiredTime(0L);
                    }
                    if (data.getTiredTime() > dayTime) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"capability.comforts.not_sleepy"), true);
                        return class_1657.class_1658.field_7531;
                    }
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    public static enum Result {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

